 IF EXISTS (
		SELECT *
		FROM SYS.procedures
		WHERE NAME = 'P_SNGPC_ENTRADA_AUTOMATICA'
		)
BEGIN
	DROP PROCEDURE P_SNGPC_ENTRADA_AUTOMATICA;
END;
GO
CREATE PROCEDURE P_SNGPC_ENTRADA_AUTOMATICA (@CD_EMP INT = 1 )
AS
BEGIN
	SET NOCOUNT ON;


    CREATE TABLE #INSERT_ENTRADAS (
		CD_EMP INT
		,CD_FILIAL INT
		,CD_PROD INT
		,CD_NF INT
		,CD_LOTE INT
	
		,DT_EMISS_NF DATETIME
		,QTDE_LANCAMENTO INT
	
		);
    
    CREATE TABLE #ENTRADAS_ERROS (
		CD_EMP INT
		,CD_FILIAL INT
		,CD_NF INT		
		,CD_LOTE INT
		,CD_LOTE_GESTAO INT
		);    


	DECLARE @CD_FILIAL INT;
    DECLARE @CD_NF INT;
    DECLARE @NR_NF INT;
    DECLARE @TP_NF INT;

	DECLARE @LANCADO INT
	DECLARE @OLD_FILIAL INT;
	DECLARE @DS_ERRO VARCHAR(255);
	DECLARE @VAL_INSERT INT;
	DECLARE @CD_PROD INT;
	DECLARE @CD_LOTE INT;	

    DECLARE @QT_IT INT;
    DECLARE @QT_ORIGINAL INT;
	DECLARE @NR_LOTE VARCHAR(60);
	DECLARE @QTDE_PROD INT;
    DECLARE @QTDE_LANCAMENTO INT;	
	DECLARE @SALDO_SNGPC INT;
	DECLARE @CD_LOTE_GESTAO INT;
	DECLARE @DATA_LIMITE DATETIME;
    DECLARE @DT_ENT DATETIME;
	DECLARE @SAIDA_AUTOMATICA INT;	
    DECLARE @ErrorMessage VARCHAR(MAX);	
    DECLARE @DT_EMISS_NF DATETIME;
	DECLARE @REGISTRO_MS  AS VARCHAR(MAX);

    PRINT 'INCIANDO'; 
	DECLARE PENDENCIAS_NOTAS CURSOR FAST_FORWARD
	FOR
 
      SELECT                                              
        IT.CD_FILIAL                                       
      , IT.CD_NF                                        
      , IT.CD_PROD   
                                                       
      , E.DT_ENT                                        
      , E.NR_NF                                         
      , E.DT_EMI_NF                                     
      , (                                               
        CASE                                                
            WHEN TRN.CD_EMP IS NULL THEN                    
          0                                        
            ELSE                                            
          1                                 
        END                                                 
      ) AS TP_NF                                                                 
                          
      , COALESCE( IT.QT_IT- CCL.QT_CANCEL, IT.QT_IT) AS QT_IT                          
      , IT.QT_IT AS QT_ORIGINAL                    
     
      ,L.QTDE_PROD AS QT_LOTE
      ,L.CD_LOTE AS COD_LOTE_GESTAO
      ,PLI.CD_LOTE
      ,LO.NR_LOTE
      ,PLI.QT_LOTE AS SALDO_SNGPC   
	  ,PLI.REGISTRO_MS
     FROM                                               
        EST_NF_ENT  (NOLOCK) E                          
                                                                        
    INNER JOIN EST_NF_ENT_IT  (NOLOCK) IT ON                   
        E.CD_EMP             = IT.CD_EMP AND                            
        E.CD_FILIAL          = IT.CD_FILIAL AND                    
        E.DT_ENT             = IT.DT_ENT AND                            
        E.CD_NF              = IT.CD_NF                                  
    INNER JOIN GLB_MOV_OP  (NOLOCK) O ON                        
        E.CD_NT_MOV           = O.CD_MOV_OP                           
    INNER JOIN EST_PROD B  (NOLOCK) ON                         
        IT.CD_EMP              = B.CD_EMP                            
        AND IT.CD_PROD         = B.CD_PROD                     
    LEFT JOIN EST_NF_ENT_IT_EST_SNGPC_PENDENTE_CANCELADO CCL  (NOLOCK) ON 
        IT.CD_EMP             = CCL.CD_EMP                          
        AND IT.CD_FILIAL      = CCL.CD_FILIAL                 
        AND IT.CD_NF          = CCL.CD_NF                           
        AND IT.CD_PROD        = CCL.CD_PROD                   
    LEFT JOIN EST_NF_ENT_EST_NF_SAI_TRANSF  (NOLOCK) AS TRN ON 
        IT.CD_EMP  = TRN.CD_EMP                            
        AND IT.CD_FILIAL       = TRN.CD_FIL_DEST                
        AND IT.CD_NF           = TRN.CD_NF_ENT     
     LEFT JOIN EST_SNGPC_ENTRADA  AS BAIXAS  (NOLOCK) ON 
        BAIXAS.CD_EMP          = IT.CD_EMP                     
        AND BAIXAS.CD_FILIAL   = IT.CD_FILIAL           
        AND BAIXAS.CD_NF       = IT.CD_NF                     
        AND BAIXAS.CD_PROD     = IT.CD_PROD  
        
      INNER JOIN EST_NF_ENT_IT_EST_PROD_CPL_LOTE    L ON          
        E.CD_EMP           = L.CD_EMP                                       
        AND E.CD_FILIAL    = L.CD_FILIAL                            
        AND E.CD_NF        = L.CD_NF  
        AND IT.CD_PROD     = L.CD_PROD                                    
      INNER JOIN EST_PROD_CPL_LOTE   LO ON                     
        LO.CD_EMP          = L.CD_EMP                                 
        AND LO.CD_FILIAL   = L.CD_FILIAL                          
        AND LO.CD_LOTE     = L.CD_LOTE 
        AND LO.CD_PROD     = L.CD_PROD                          
                              
      LEFT  JOIN EST_PROD_EST_SNGPC_LOTE  PL                      
        ON  PL.NR_LOTE    =LO.NR_LOTE    --RELACIONAR LOTE GESTAO LOTE SNCPC                      
        AND PL.CD_PROD    =LO.CD_PROD                        
      LEFT  JOIN EST_PROD_EST_SNGPC_LOTE_CPL  PLI                 
        ON    PLI.CD_EMP     = PL.CD_EMP                             
        AND   PLI.CD_FILIAL  = 1
        AND   PLI.CD_LOTE    = PL.CD_LOTE   
        
      INNER JOIN PRC_FILIAL_CONFIG VALFILIAL  ON
               VALFILIAL.CD_FILIAL   = E.CD_FILIAL  
               AND VALFILIAL.CD_CHAVE = 'SNGPC_Confronta_Quantidade_Lote_Venda'
               AND VALFILIAL.VALOR  =1                           
      WHERE                                                  
         B.CONTROLE_SNGPC     =  1 
         AND COALESCE( O.ATU_EST,1) =1 
         AND   E.CD_EMP       =   1             
        
         AND   E.DT_EMI_NF    > DATEADD(MONTH, - 1, GETDATE()) --TRAZER SO DO ULTIMO MES    
         AND   BAIXAS.CD_NF     IS NULL
       
      ORDER  BY
        E.CD_FILIAL
        ,E.CD_NF  
        
        
    OPEN PENDENCIAS_NOTAS;

	FETCH NEXT
	FROM PENDENCIAS_NOTAS
	INTO 
        @CD_FILIAL
		,@CD_NF
		,@CD_PROD
     
		,@DT_ENT
		,@NR_NF
		,@DT_EMISS_NF
		,@TP_NF
		,@QT_IT
		,@QT_ORIGINAL
		,@QTDE_LANCAMENTO
		,@CD_LOTE_GESTAO
		,@CD_LOTE
		,@NR_LOTE
		,@SALDO_SNGPC
		,@REGISTRO_MS

	WHILE @@FETCH_STATUS = 0
	BEGIN
     SET @VAL_INSERT = 1;
       PRINT 'TRATANDO NOTA DE ENTRADA FILIAL - ' + CAST(@CD_FILIAL AS VARCHAR(30)) + '  NF ' + CAST(@NR_NF	 AS VARCHAR(30));		
        --VALIDAR DATA DE LANÇAMENTO
        IF @OLD_FILIAL <> @CD_FILIAL
        BEGIN
            SET @DATA_LIMITE = (
                    SELECT COALESCE(MAX(DT_FINAL), '1900-01-01')
                    FROM EST_SNGPC_RELATORIOS_ANVISA(NOLOCK)
                    WHERE CD_EMP = @CD_EMP
                        AND CD_FILIAL = @CD_FILIAL
                        AND ACEITO = 1
                    );
            SET @SAIDA_AUTOMATICA = (
                    SELECT VALOR
                    FROM PRC_FILIAL_CONFIG(NOLOCK)
                    WHERE CD_FILIAL = @CD_FILIAL
                        AND CD_CHAVE = 'Confronta_Quantidade_Lote_SNGPC_Venda'
                    )
        END;
        IF @CD_LOTE_GESTAO IS NULL
        BEGIN        
          SET @DS_ERRO = 'Lote NAO informado na tabela EST_NF_ENT_IT_EST_PROD_CPL_LOTE,verificar lançamento da nota de Etrada'
          SET @VAL_INSERT = 0;
        END;
         IF  @CD_LOTE IS NULL 
        BEGIN
          SET @DS_ERRO = 'Lote '+ cast(coalesce(@NR_LOTE, ' ') AS VARCHAR(60)) +' NAO cadastrado NAO pode ser asociado a nehum lote no sngpc pela numeracao '
          SET @VAL_INSERT = 0;
        END

        IF  @SALDO_SNGPC IS NULL 
        BEGIN
          SET @DS_ERRO = 'Lote '+ cast(coalesce(@NR_LOTE, ' ') AS VARCHAR(60)) +' NAO cadastrado no SNGPC nesta filial '
          SET @VAL_INSERT = 0;
        END
        IF COALESCE(  @QTDE_LANCAMENTO,0) > COALESCE( @SALDO_SNGPC,0)
        BEGIN
          SET @DS_ERRO = @DS_ERRO + ' Quantidade de lote insuficiente SNGPC : ' + cast(coalesce(@SALDO_SNGPC, 0) AS VARCHAR(60))
          SET @VAL_INSERT = 0;
        END;
        IF @DT_ENT < @DATA_LIMITE
		BEGIN
		  SET @DS_ERRO = @DS_ERRO + 'Data de entrada da nota esta em um  periodo ja enviado para anvisa'
		  SET @VAL_INSERT = 0;		
		END;
		IF LEN(@DS_ERRO) > 1
			SET @VAL_INSERT = 0

		IF @VAL_INSERT = 1
		BEGIN
            PRINT 'NOTA VALIDA : FILIAL ' + CAST(@CD_FILIAL AS VARCHAR(30)) + '  NOTA ' + CAST(@NR_NF AS VARCHAR(30)) + ' PRODUTO : ' + CAST(@CD_PROD AS VARCHAR(30)) ;
			INSERT INTO #INSERT_ENTRADAS (
				CD_EMP
				,CD_FILIAL
				,CD_PROD
				,CD_NF
				,CD_LOTE			
				,DT_EMISS_NF
				,QTDE_LANCAMENTO
				
				)
			VALUES (
				@CD_EMP
				,@CD_FILIAL
				,@CD_PROD
				,@CD_NF
				,@CD_LOTE		
				,@DT_ENT --usar a data de entrada
				,@QTDE_LANCAMENTO
				
				)				
		END
		ELSE
		BEGIN
			PRINT 'INSERINDO ERRO : FILIAL ' + CAST(@CD_FILIAL AS VARCHAR(30)) + '  NOTA ' + CAST(@NR_NF AS VARCHAR(30)) + ' PRODUTO : ' + CAST(@CD_PROD AS VARCHAR(30)) + ' ' + @DS_ERRO;

			INSERT INTO #ENTRADAS_ERROS (
				CD_EMP
				,CD_FILIAL
				,CD_NF
		
				,CD_LOTE
				,CD_LOTE_GESTAO
				)
			VALUES (
				@CD_EMP
				,@CD_FILIAL
				,@CD_NF
			
				,@CD_LOTE
				,@CD_LOTE_GESTAO
				);

			INSERT INTO EST_SNGPC_PEND_ENTRADAS_NOTA_AUDIT (
				CD_EMP
				,CD_FILIAL
				,CD_PROD
				,NR_LOTE
			
				,CD_NF
				,DT_CAD
				,DS_ERRO
				)
			VALUES (
				@CD_EMP
				,@CD_FILIAL
				,@CD_PROD
				,@NR_LOTE
			
				,@CD_NF
				,GETDATE()
				,@DS_ERRO
				)
		END

		SET @OLD_FILIAL = @CD_FILIAL;

		FETCH NEXT
		FROM PENDENCIAS_NOTAS
		INTO 
        @CD_FILIAL
		,@CD_NF
		,@CD_PROD       
		,@DT_ENT
		,@NR_NF
		,@DT_EMISS_NF
		,@TP_NF
		,@QT_IT
		,@QT_ORIGINAL
		,@QTDE_LANCAMENTO
		,@CD_LOTE_GESTAO
		,@CD_LOTE
		,@NR_LOTE
		,@SALDO_SNGPC
		,@REGISTRO_MS
    END;
    CLOSE PENDENCIAS_NOTAS;
    DEALLOCATE  PENDENCIAS_NOTAS;

	DECLARE PERSITIR_NOTA CURSOR FAST_FORWARD
	FOR
	SELECT 
		*
	FROM 
		#INSERT_ENTRADAS
	WHERE 
		NOT EXISTS (
			SELECT 
				CD_NF
			FROM 
				#ENTRADAS_ERROS
			WHERE 
				#ENTRADAS_ERROS.CD_EMP = #INSERT_ENTRADAS.CD_EMP
				AND #ENTRADAS_ERROS.CD_FILIAL = #INSERT_ENTRADAS.CD_FILIAL
				AND #ENTRADAS_ERROS.CD_NF = #INSERT_ENTRADAS.CD_NF
			)
    PRINT 'ABRINDO INSERÇÃO DE TRANSFERENCIAS'
	OPEN PERSITIR_NOTA;

	FETCH NEXT
	FROM PERSITIR_NOTA
	INTO @CD_EMP
		,@CD_FILIAL
		,@CD_PROD
		,@CD_NF
		,@CD_LOTE
		
		,@DT_ENT
		,@QTDE_LANCAMENTO
		
	WHILE @@FETCH_STATUS = 0
	BEGIN    
		BEGIN TRY

		  
		  PRINT 'INSERINDO NOTA   FILIAL: ' + CAST(@CD_FILIAL AS VARCHAR(30)) + '  NOTA ' + CAST(@NR_NF AS VARCHAR(30)) + ' PRODUTO : ' + CAST(@CD_PROD AS VARCHAR(30)) ;
		  EXEC P_EST_SNGPC_ENTRADA_INSERIR
		   
            @CD_EMP
			,@CD_FILIAL
			,@CD_NF
			,@CD_PROD
			,TP_ENT	     	
	     	,@CD_LOTE
	     	,@DT_ENT
		    ,@QTDE_LANCAMENTO
		     ,1   --USUARIO DO GESTAO
		     ,0  --ZERO NA MOVIMENTACAO
             ,@CD_PROD
		     ,@REGISTRO_MS 		
		     ,'AUTO_1.3';

	     
		END TRY
		BEGIN CATCH 
          SELECT 
              @ErrorMessage = ERROR_MESSAGE()         		 
		  SET  @DS_ERRO ='ERRO P_EST_SNGPC_ENTRADA_INSERIR ' + COALESCE( @ErrorMessage ,'ERRO DESCONHECIDO') ;
		  PRINT 'ERRO NA PROCEDURE DE INSERCAO DE ENTRADAS : '+@ErrorMessage;		  
		  INSERT INTO  EST_SNGPC_PEND_ENTRADAS_NOTA_AUDIT (
				CD_EMP
				,CD_FILIAL
				,CD_PROD
				,NR_LOTE
				
				,CD_NF
				,DT_CAD
				,DS_ERRO
				)
			VALUES (
				@CD_EMP
				,@CD_FILIAL
				,@CD_PROD
				,@NR_LOTE
				
				,@CD_NF
				,GETDATE()
				,@DS_ERRO
				)
		END CATCH  

		FETCH NEXT
		FROM PERSITIR_NOTA
		INTO @CD_EMP
			,@CD_FILIAL
			,@CD_PROD
			,@CD_NF
			,@CD_LOTE
	
			,@DT_EMISS_NF
			,@QTDE_PROD
			
	END;
	CLOSE PERSITIR_NOTA;
	DEALLOCATE PERSITIR_NOTA;   
    PRINT 'FINALIZADO PROCESSAMENTO';		    
END